#include "rmixslider.h"
#include "mixerhandle.h"

rmixSlider::rmixSlider(snd_ctl_t *ctl, snd_hctl_elem_t *elem, ushort channel, QLabel *lbVal, rmixSlider *prev) {
	m_elem= elem;
	m_channel= channel;
	m_lbVal= lbVal;
	m_ctl= ctl;
	m_prev= prev;
	snd_ctl_elem_value_malloc(&m_val);
	snd_ctl_elem_info_malloc(&m_info);
	snd_hctl_elem_info(elem, m_info);
	snd_ctl_elem_id_malloc(&m_elemId);
	snd_hctl_elem_get_id(m_elem, m_elemId);

	setOrientation(Qt::Horizontal);
	setMaximum(snd_ctl_elem_info_get_max(m_info));
	setMinimum(snd_ctl_elem_info_get_min(m_info));
	connect(this, SIGNAL(valueChanged(int)), this, SLOT(changeVal(int)));

	if(snd_ctl_convert_to_dB(m_ctl, m_elemId, 1, &m_dbVal))
	{
		m_isDb = 0;
		m_lbVal->setFixedWidth(24);
	}
	else
	{
		m_isDb = 1;
		m_lbVal->setFixedWidth(64);
	}
	snd_hctl_elem_set_callback_private(elem, new mixerHandle::callbackData{ mixerHandle::SL, this });
	snd_hctl_elem_set_callback(elem, callback);
	updat();
}

rmixSlider::~rmixSlider() {
	snd_ctl_elem_info_free(m_info);
	snd_ctl_elem_value_free(m_val);
	snd_ctl_elem_id_free(m_elemId);
	snd_hctl_elem_set_callback(m_elem, nullptr);
	snd_hctl_elem_set_callback_private(m_elem, nullptr);
}

void rmixSlider::changeVal(int newVal) {
	snd_hctl_elem_read(m_elem, m_val);
	snd_ctl_elem_value_set_integer(m_val, m_channel, newVal);
	snd_hctl_elem_write(m_elem, m_val);
}

void rmixSlider::updat() {
	if(m_prev != nullptr)
		m_prev->updat();
	snd_hctl_elem_read(m_elem, m_val);
	long value= snd_ctl_elem_value_get_integer(m_val, m_channel);
	blockSignals(1);
	setValue(value);
	blockSignals(0);
	if(m_isDb)
	{
		snd_ctl_convert_to_dB(m_ctl, m_elemId, value, &m_dbVal);
		m_lbVal->setText(QString::number(m_dbVal / 100.0, 'f', 2) + " dB");
	} else
	{
		m_lbVal->setText(QString::number(value));
	}
}
