#ifndef PARAMSWIDGET_H
#define PARAMSWIDGET_H

#include "cardselector.h"
#include "mixerhandle.h"
#include "rmixsliderbox.h"
#include <QTabWidget>

class ParamsWidget: public QTabWidget {
	Q_OBJECT
private:
	mixerHandle *m_mixer;
	QVBoxLayout *m_lOut, *m_lIn, *m_lInt, *m_lMix, *m_lDig, *m_lMisc;
	QFormLayout *m_lChmap, *m_lJacksIn, *m_lJacksOut;
	QWidget *m_wOut, *m_wIn, *m_wInt, *m_wMix, *m_wDig, *m_wMisc;
	snd_ctl_elem_info_t *m_info;
	QTimer *m_timer;
	CardSelector *m_cs;

public:
	ParamsWidget(CardSelector *cs);
	~ParamsWidget();
	void clear();
	void populate();
	rmixSliderBox *ensureSlBox(QString name, rmixSliderBox::ctrlType_t ctrlType, QWidget *parent); // let there be correct box to put new control in
	QFormLayout *ensureMiscBox(QString name, QVBoxLayout *parentL);
	void addMiscJack(QFormLayout *lBox, snd_hctl_elem_t *elem, QString name, QString index, ushort numCh);
	void addMiscEntry(QFormLayout *lBox, snd_hctl_elem_t *elem, QString name, ushort numCh);
	bool isInput(QString elemName);
	bool isInternal(QString elemName);
public slots:
	void update();
};

#endif
